<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Staff extends Model 
{

    protected $table = 'staffs';
    public $timestamps = true;
    protected $fillable = array('name', 'password', 'phone', 'image', 'staff_type', 'email');

    public function products()
    {
        return $this->belongsToMany('App\Models\Product', 'product_id');
    }

    public function addresses()
    {
        return $this->hasMany('app\Models\Address', 'address_id');
    }

}